/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.stone;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.util.FallingBlockManager;
import net.dries007.tfc.objects.Gem;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.stone.BlockStoneAnvil;
import net.dries007.tfc.objects.items.ItemGem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockRockRaw
extends BlockRockVariant {
    public static final PropertyBool CAN_FALL = PropertyBool.func_177716_a((String)"can_fall");

    public BlockRockRaw(Rock.Type type, Rock rock) {
        super(type, rock);
        FallingBlockManager.Specification spec = new FallingBlockManager.Specification(type.getFallingSpecification());
        FallingBlockManager.registerFallable(this, spec);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)CAN_FALL, (Comparable)Boolean.valueOf(true)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CAN_FALL, (Comparable)Boolean.valueOf(meta == 0));
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        return (Boolean)state.func_177229_b((IProperty)CAN_FALL) != false ? 0 : 1;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (((Boolean)state.func_177229_b((IProperty)CAN_FALL)).booleanValue()) {
            for (EnumFacing face : EnumFacing.field_82609_l) {
                BlockPos offsetPos = pos.func_177972_a(face);
                IBlockState faceState = worldIn.func_180495_p(offsetPos);
                if (!faceState.func_177230_c().isSideSolid(faceState, (IBlockAccess)worldIn, offsetPos, face.func_176734_d())) continue;
                return;
            }
            worldIn.func_175698_g(pos);
            Helpers.spawnItemStack(worldIn, pos, new ItemStack(state.func_177230_c(), 1));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184614_ca();
        if (ConfigTFC.General.OVERRIDES.enableStoneAnvil && OreDictionaryHelper.doesStackMatchOre(stack, "hammer") && !worldIn.func_175677_d(pos.func_177984_a(), true)) {
            BlockRockVariant anvil;
            if (!worldIn.field_72995_K && (anvil = BlockRockVariant.get(this.rock, Rock.Type.ANVIL)) instanceof BlockStoneAnvil) {
                worldIn.func_175656_a(pos, anvil.func_176223_P());
            }
            return true;
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CAN_FALL});
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (RANDOM.nextDouble() < ConfigTFC.General.MISC.stoneGemDropChance) {
            drops.add((Object)ItemGem.get(Gem.getRandomDropGem(RANDOM), Gem.Grade.randomGrade(RANDOM), 1));
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }
}

